:: Verify the supported OS
:: Verify user logged in as with administrator privileges
:: Verify Dotnet Framework v3.5 SP1 or greater is installed and if not then install Dotnet Framework v3.5 SP1
:: Resume the installation of Insight 2 application

@Echo Off

Set OS_Found=0
Set IsWin10=0
Set "IsSilent=%~1"
Set "InstallPath=%~2"
IF "%InstallPath%"=="" goto checkinstallpath
If Not Exist %InstallPath% mkdir "%InstallPath%"
IF Not exist %InstallPath% Echo "%InstallPath% is invalid..." >> C:\Temp\Insight2_Install.log 
IF Not exist %InstallPath% goto Exit_Installation
rmdir "%InstallPath%"

:checkinstallpath
IF NOT "%InstallPath%"=="" GOTO InstallPathAvailable
Set InstallPath="C:\Program Files (x86)\Rotork Controls\Insight 2"


:InstallPathAvailable

If Not Exist "C:\Temp" Mkdir "C:\Temp" > nul
systeminfo > %temp%\sysinfo.txt

type %temp%\sysinfo.txt | Find /I "windows xp" > nul
if %ERRORLEVEL% == 0 Set OS_Found=1

type %temp%\sysinfo.txt | Find /I "windows vista" > nul
if %ERRORLEVEL% == 0 Set OS_Found=1

type %temp%\sysinfo.txt | Find /I "windows 7" > nul
if %ERRORLEVEL% == 0 Set OS_Found=1

type %temp%\sysinfo.txt | Find /I "windows 10" > nul
if %ERRORLEVEL% == 0 Set OS_Found=1
if %ERRORLEVEL% == 0 Set IsWin10=1

del %temp%\sysinfo.txt

if %OS_Found% == 1 (goto OS_Supported) else (goto OS_NotSupported)

:OS_NotSupported
IF /I "%IsSilent%"=="/q" GOTO OS_NotSupported_Silent
Echo x=msgbox("Current version of operating system does not fully support Insight 2. Continue ?",4+48,"Insight 2") >> %TEMP%\tempmsg.vbs
Echo if x=vbYes then wscript.quit 6 >> %TEMP%\tempmsg.vbs
Echo if x=vbNo then wscript.quit 7 >> %TEMP%\tempmsg.vbs&%TEMP%\tempmsg.vbs
if %ERRORLEVEL% == 6 (goto OS_Supported) else (goto Exit_Installation)

GOTO OS_NotSupported_End
:OS_NotSupported_Silent
Echo "Current version of operating system does not fully support Insight 2. Attempting to install..." >> C:\Temp\Insight2_Install.log
:OS_NotSupported_End


CLS

:OS_Supported

net session >nul 2>&1
if  %errorLevel% == 0 goto User_Admin
    Echo "Current command prompt not opened in administration mode..." >> C:\Temp\Insight2_Install.log
    

CLS

:User_Admin

Set Display_Msg=

reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\NET Framework Setup\NDP\v3.5"

CLS
if Not %ERRORLEVEL% == 0 goto FW_Notfound

For /F "tokens=*" %%b in ('reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\NET Framework Setup\NDP\v3.5" /v "SP"^|Find /I "SP"') do set regEntry=%%b
echo %regEntry% | Find /I "0x0" > nul

CLS
if Not %ERRORLEVEL% == 0 (goto FW_Found) else (goto FW_Notfound)

:FW_Found
goto Resume_Install

:FW_Notfound
IF Not "%IsSilent%"=="/q" GOTO Install_FW
Echo "Framework v3.5 SP1 not found in System. Installation will be aborted." >> C:\Temp\Insight2_Install.log
goto Exit_Installation

:Install_FW
Set Display_Msg="Installation of Framework v3.5 SP1 was aborted by the user"
Echo Installing Dotnet Framework 3.5 SP1
"%~dp0..\Prerequisite\dotnetfx35.exe"

reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\NET Framework Setup\NDP\v3.5"

CLS
if Not %ERRORLEVEL% == 0 goto Exit_Installation

For /F "tokens=*" %%b in ('reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\NET Framework Setup\NDP\v3.5" /v "SP"^|Find /I "SP"') do set regEntry=%%b
echo %regEntry% | Find /I "0x0" > nul

CLS
if NOT %ERRORLEVEL% == 0 goto Resume_Install

if %IsWin10%==1 Set Display_Msg= "Dot Net Framework 3.5 is Disabled. Please Enable it in Windows Features."
goto Exit_Installation


:Resume_Install
Set Display_Msg=
Echo Starting Rotork Insight 2 setup

If Not Exist "C:\Temp" Mkdir "C:\Temp" > nul
Echo Launch Condition Log>C:\Temp\LaunchCondition.log

IF Not "%IsSilent%"=="/q" GOTO notsilent


"%~dp0..\Insight2_Setup.msi" /L*V "C:\Temp\Insight2_msi_Install.log" /q TARGETDIR=%InstallPath%
goto Exit_Installation
:notsilent
"%~dp0..\Insight2_Setup.msi"
goto Exit_Installation

:Exit_Installation


Del C:\Temp\LaunchCondition.log /Q /S > nul
CLS

IF "%IsSilent%"=="/q" GOTO DisplayMsg_Silent
if Not %Display_Msg% == nul Echo Msgbox %Display_Msg%,64,"Insight 2">%TEMP%\tempmsg.vbs&%TEMP%\tempmsg.vbs

:DisplayMsg_Silent
echo %Display_Msg%>> C:\Temp\Insight2_Install.log


Del %TEMP%\tempmsg.vbs /Q /S > nul
CLS
Exit